<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php  init_head(); ?>

<style>
    .repair-job-card {
        background: #fff;
        border: 1px solid #e5e5e5;
        border-radius: 4px;
        padding: 15px;
        margin-bottom: 20px;
        display: flex;
        flex-direction: column;
        height: 100%;
        transition: box-shadow 0.3s;
    }
    .repair-job-card:hover {
        box-shadow: 0 4px 10px rgba(0,0,0,0.05);
    }
    .rj-card-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 10px;
    }
    .rj-status-badge {
        font-size: 12px;
        padding: 3px 8px;
        border-radius: 3px;
        font-weight: 600;
    }
    .rj-card-body h4 {
        font-size: 18px;
        font-weight: bold;
        margin: 0 0 5px 0;
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;
    }
    .rj-card-body p {
        font-size: 13px;
        color: #777;
        margin: 0 0 15px 0;
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;
    }
    .rj-timeline {
        position: relative;
        margin: 20px 0;
    }
    .rj-progress-bar-bg {
        height: 4px;
        background: #eee;
        border-radius: 2px;
        position: relative;
        width: 100%;
    }
    .rj-progress-bar-fill {
        height: 4px;
        background: #84c529;
        border-radius: 2px;
        position: absolute;
        top: 0;
        left: 0;
    }
    .rj-timeline-dates {
        display: flex;
        justify-content: space-between;
        font-size: 11px;
        color: #999;
        margin-top: 5px;
    }
    .rj-dot {
        width: 8px;
        height: 8px;
        border-radius: 50%;
        background: #fff;
        border: 2px solid #333;
        position: absolute;
        top: -2px;
        z-index: 2;
    }
    .rj-dot.start { left: 0; border-color: #333; }
    .rj-dot.end { right: 0; border-color: #ddd; }
    .rj-card-footer {
        margin-top: auto;
        display: flex;
        justify-content: space-between;
        align-items: center;
        border-top: 1px solid #f0f0f0;
        padding-top: 10px;
    }
    .rj-mechanic {
        display: flex;
        align-items: center;
        gap: 8px;
    }
    .rj-mechanic img {
        width: 24px;
        height: 24px;
        border-radius: 50%;
        object-fit: cover;
    }
    .rj-mechanic span {
        font-size: 12px;
        font-weight: 600;
        color: #333;
    }
    .rj-arrow-btn {
        width: 28px;
        height: 28px;
        border-radius: 50%;
        background: #000;
        color: #fff;
        display: flex;
        align-items: center;
        justify-content: center;
        text-decoration: none;
    }
    .rj-arrow-btn:hover {
        background: #333;
        color: #fff;
    }
    .device-link {
        color: #555;
        text-decoration: none;
        font-weight: 600;
        transition: color 0.2s;
    }
    .device-link:hover {
        color: #3b82f6;
        text-decoration: underline;
    }
    .repair-job-card-item {
        padding-left: 12.5px;
        padding-right: 12.5px;
    }
</style>
<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="panel_s">
                    <div class="panel-body">
                        <div class="row">
                            <div class="col-md-6">
                                <h4><?php echo _l('wshop_repair_jobs'); ?></h4>
                            </div>
                            <div class="col-md-6">
                                <?php if(has_permission('workshop_repair_job', '', 'create')){ ?>
                                    <a href="<?php echo admin_url('workshop/add_edit_repair_job'); ?>" class="btn btn-info pull-right display-block">
                                        <?php echo _l('wshop_new'); ?>
                                    </a>
                                <?php } ?>
                                <a href="<?php echo admin_url('workshop/repair_job_calendar'); ?>" class="btn btn-default mright5 pull-right hidden-xs" data-toggle="tooltip" data-placement="top" data-title="Switch to Calendar" data-original-title="" title="">
                                    <i class="fa-solid fa-calendar-days"></i>
                                </a>
                            </div>
                        </div>

                        <?php 
                        $warranty_status = wshop_warranty_status();
                         ?>
                        <div class="row">
                            <div class="col-md-3">
                                <?php echo render_date_input('from_date_filter', '', '', ['placeholder' => _l('wshop_from_date')]); ?>
                            </div>
                            <div class="col-md-3">
                                <?php echo render_date_input('to_date_filter', '', '', ['placeholder' => _l('wshop_to_date')]); ?>
                            </div>
                            
                            <div class="col-md-3">
                                <?php echo render_select('device_filter',$devices,array('id','name'),'','',array('data-width'=>'100%','data-none-selected-text'=>_l('wshop_device')),array(),'no-mbot'); ?>
                            </div>
                            <div class="col-md-3">
                                <?php echo render_select('appointment_type_filter', $appointment_types, ['id', 'name'], '', '', ['data-none-selected-text' => _l('wshop_appointment_type')]); ?>
                            </div>
                            
                            
                        </div>
                        <div class="clearfix"></div>
                        <hr>

                        <div class="row mtop15 mbot15">
                            <div class="col-md-12 text-right">
                                <div class="btn-group pull-right mleft4 btn-with-tooltip-group _filter_data" data-toggle="tooltip" data-title="<?php echo _l('filter_by'); ?>" style="margin-bottom: 10px;">
                                <button type="button" class="btn btn-default active" id="btn-grid-view" onclick="switch_view('grid')">
                                    <i class="fa fa-th-large"></i>
                                </button>
                                <button type="button" class="btn btn-default" id="btn-list-view" onclick="switch_view('list')">
                                    <i class="fa fa-list"></i>
                                </button>
                        </div>
                        </div>
                        <div class="clearfix"></div>
                        
                        <div id="repair-job-grid-view">

                            <div class="row" style="display: flex; flex-wrap: wrap; margin-left: 2.5px; margin-right: 2.5px;">
                                <?php 
                                $initial_limit = 50; 
                                $count = 0;
                                foreach($repair_jobs as $job){ 
                                    $count++;
                                    $hidden_class = ($count > $initial_limit) ? 'hide' : '';
                                    
                                    // Status Logic
                                    $status_label = '';
                                    $status_color = '#777';
                                    $status_bg = '#f0f0f0';
                                    $status_text_class = 'text-default';
                                    
                                    if($job['status'] == 'Booked_In'){
                                        $status_color = '#3b82f6'; // Blue
                                    } elseif($job['status'] == 'In_Progress' || $job['status'] == 'wshop_in_progress'){
                                        $status_color = '#eab308'; // Yellow/Gold
                                    } elseif($job['status'] == 'Completed'){
                                        $status_color = '#22c55e'; // Green
                                    } elseif($job['status'] == 'Cancelled'){
                                        $status_color = '#ef4444'; // Red
                                    } elseif($job['status'] == 'Waiting_For_Parts'){
                                        $status_color = '#f97316'; // Orange
                                    } elseif($job['status'] == 'Customer_Notified'){
                                        $status_color = '#06b6d4'; // Cyan
                                    } elseif($job['status'] == 'Complete_Awaiting_Finalise'){
                                        $status_color = '#14b8a6'; // Teal
                                    } elseif($job['status'] == 'Finalised'){
                                        $status_color = '#15803d'; // Dark Green
                                    } elseif($job['status'] == 'Waiting_For_User_Approval'){
                                        $status_color = '#8b5cf6'; // Purple
                                    } elseif($job['status'] == 'Pending'){
                                        $status_color = '#64748b'; // Slate
                                    }
                                    
                                    /* Overwrite logic for render_repair_job_status_html as we want custom card colors */


                                    // Timeline Logic
                                    $start_date = strtotime($job['datecreated']); // Assuming datecreated is better start time, or appointment_date
                                    if(!empty($job['appointment_date'])) $start_date = strtotime($job['appointment_date']);
                                    
                                    $end_date = strtotime($job['estimated_completion_date']);
                                    $now = time();
                                    
                                    $total_duration = $end_date - $start_date;
                                    if($total_duration <= 0) $total_duration = 1; // Prevent division by zero
                                    
                                    $elapsed = $now - $start_date;
                                    $percent = ($elapsed / $total_duration) * 100;
                                    
                                    if($percent < 0) $percent = 0;
                                    if($percent > 100) $percent = 100;

                                    if(empty($job['estimated_completion_date'])) $percent = 0; // No end date
                                    
                                    // Overdue check
                                    $is_overdue = ($now > $end_date && $job['status'] != 'Completed' && $job['status'] != 'Cancelled' && !empty($job['estimated_completion_date']));
                                    
                                    // Visuals
                                    $border_color = $status_color; 
                                    if($is_overdue) {
                                         // Optional: if you want border to be red when overdue.
                                         // $border_color = '#ef4444'; 
                                         // For now, user asked for "status color", so we keep the mapped color.
                                    }

                                    $progress_bar_color = '#84c529'; // Fixed uniform color (Green)

                                    $mechanic_name = ''; 
                                    $mechanic_id = $job['sale_agent'];
                                    // Use 'small' as generic type or leave empty. Passing array caused error.
                                    $mechanic_img_url = staff_profile_image_url($mechanic_id, 'small'); 
                                    $mechanic_name = get_staff_full_name($mechanic_id);
                                    if(empty($mechanic_name)) { $mechanic_name = '--'; }

                                    $device_name = $job['device_name'] ?? 'Device Name';
                                    
                                ?>
                                <div class="col-lg-3 col-md-3 col-sm-6 repair-job-card-item <?php echo $hidden_class; ?>"
                                     data-client-id="<?php echo $job['client_id']; ?>"
                                     data-device-id="<?php echo $job['device_id']; ?>"
                                     data-appointment-type="<?php echo $job['appointment_type_id']; ?>"
                                     data-date="<?php echo date('Y-m-d', $start_date); ?>"
                                     style="margin-bottom: 25px;"
                                     >
                                    <div class="panel_s" style="width: 100%; display: flex; flex-direction: column; height: 100%; margin-bottom: 0; border-top: 3px solid <?php echo $border_color; ?>;">
                                        <div class="panel-body" style="flex: 1; display: flex; flex-direction: column;">
                                            <div class="rj-card-header">
                                                <span style="font-size: 14px; font-weight: bold; color: #555;">#<?php echo $job['id']; ?></span>
                                                <?php echo render_repair_job_status_html($job['id'], '', $job['status']); ?>
                                            </div>
                                            <div class="rj-card-body">
                                                <h4 title="<?php echo $job['name']; ?>"><?php echo (!empty($job['name']) ? $job['name'] : _l('wshop_repair_job')); ?></h4>
                                                <p title="<?php echo $device_name; ?>">
                                                    <a href="<?php echo admin_url('workshop/device_detail/' . $job['device_id']); ?>" class="device-link">
                                                        <?php echo $device_name; ?>
                                                    </a>
                                                </p>
                                            </div>
                                            <div class="rj-timeline">
                                                <div class="rj-progress-bar-bg">
                                                    <div class="rj-progress-bar-fill" style="width: <?php echo $percent; ?>%; background: <?php echo $progress_bar_color; ?>;"></div>
                                                    <div class="rj-dot start" style="border-color: <?php echo ($percent > 0 ? $progress_bar_color : '#333'); ?>"></div>
                                                    <div class="rj-dot end" style="border-color: <?php echo ($percent >= 100 ? $progress_bar_color : '#ddd'); ?>"></div>
                                                </div>
                                                <div class="rj-timeline-dates">
                                                    <span><?php echo _d(date('Y-m-d', $start_date)); ?></span>
                                                    <span><?php echo ($job['estimated_completion_date'] ? _d($job['estimated_completion_date']) : '--'); ?></span>
                                                </div>
                                                <div class="mtop10" style="padding-top: 5px;">
                                                    <span style="font-size: 13px; color: #333; display: block;">
                                                        <strong>Треккод:</strong> <?php echo $job['job_tracking_number']; ?>
                                                    </span>
                                                </div>
                                            </div>
                                            <div class="rj-card-footer">
                                                <div class="rj-mechanic">
                                                    <img src="<?php echo $mechanic_img_url; ?>" class="staff-profile-image-small" style="width: 24px; height: 24px; border-radius: 50%; object-fit: cover;">
                                                    <span><?php echo $mechanic_name; ?></span>
                                                </div>
                                                <a href="<?php echo admin_url('workshop/repair_job_detail/'.$job['id']); ?>" class="rj-arrow-btn">
                                                    <i class="fa fa-angle-right"></i>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <?php } ?>
                                
                                <?php if(count($repair_jobs) == 0){ ?>
                                    <div class="col-md-12 text-center text-muted mtop20">
                                        <?php echo _l('no_repair_jobs_found'); ?>
                                    </div>
                                <?php } ?>
                            </div>
                        </div>

                        <div id="repair-job-list-view" class="hide" style="padding: 0 15px;">
                            <?php 
                            render_datatable(
                                array(
                                    _l('id'),
                                    _l('wshop_job_tracking_number'),
                                    _l('wshop_repair_job_id'),
                                    array(
                                        'name'=>_l('wshop_appointment_date'),
                                        'th_attrs' => [
                                            'style' => 'max-width:95px',
                                        ],
                                    ),
                                    array(
                                        'name'=>_l('wshop_estimated_completion_date'),
                                        'th_attrs' => [
                                            'style' => 'max-width:150px',
                                        ],
                                    ),
                                    _l('wshop_appointment_type'),
                                    array(
                                        'name'=>_l('client'),
                                        'th_attrs' => [
                                            'style' => 'min-width:210px',
                                        ],
                                    ),
                                    _l('wshop_branch_phone'),
                                    array(
                                        'name'=>_l('wshop_device'),
                                        'th_attrs' => [
                                            'style' => 'min-width:210px',
                                        ],
                                    ),
                                    _l('wshop_model'),
                                    _l('wshop_mechanic'),
                                    _l('wshop_total'),
                                    _l('wshop_estimated_hours'),
                                    _l('wshop_status'),
                                    _l('invoice'),
                                ),'repair_job_table'
                            );
                            ?>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div id="modal_wrapper"></div>

<?php init_tail(); ?>
<?php 
require('modules/workshop/assets/js/repair_jobs/manage_js.php');
?>
</body>
</html>
